/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.net;

import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.api.DataSyncAPI;
import dev.upcraft.datasync.content.DataRegistry;
import dev.upcraft.datasync.content.DataStore;
import dev.upcraft.datasync.content.DataType;
import dev.upcraft.datasync.net.S2CUpdatePlayerDataPacket;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public record C2SUpdatePlayerDataPacket(@Nullable class_2960 dataTypeId) implements FabricPacket
{
    public static final class_2960 ID = DataSyncMod.id("c2s_update_player_data");
    public static final PacketType<C2SUpdatePlayerDataPacket> TYPE = PacketType.create((class_2960)ID, C2SUpdatePlayerDataPacket::fromNetwork);

    public boolean refreshAll() {
        return this.dataTypeId() == null;
    }

    @Environment(value=EnvType.CLIENT)
    public static void trySend(@Nullable class_2960 id) {
        if (ClientPlayNetworking.canSend(TYPE)) {
            ClientPlayNetworking.send((FabricPacket)new C2SUpdatePlayerDataPacket(id));
        }
    }

    public void handle(class_3222 serverPlayer, PacketSender packetSender) {
        UUID originId = serverPlayer.method_7334().getId();
        MinecraftServer server = Objects.requireNonNull(serverPlayer.method_5682());
        if (this.refreshAll()) {
            DataSyncAPI.refreshAllPlayerData(originId);
        } else {
            DataType<?> type = DataRegistry.getById(this.dataTypeId());
            if (type != null) {
                DataStore.getPlayerLookup(serverPlayer.method_7334().getId(), type).reload();
            } else {
                DataSyncMod.LOGGER.trace("Relaying sync packet for unknown data type '{}' for player {} ({})", new Object[]{this.dataTypeId(), serverPlayer.method_7334().getName(), originId});
            }
        }
        PlayerLookup.all((MinecraftServer)server).stream().filter(p -> p != serverPlayer).forEach(p -> S2CUpdatePlayerDataPacket.send(p, originId, this.dataTypeId()));
    }

    private static C2SUpdatePlayerDataPacket fromNetwork(class_2540 friendlyByteBuf) {
        boolean single = friendlyByteBuf.readBoolean();
        class_2960 dataType = null;
        if (single) {
            dataType = friendlyByteBuf.method_10810();
        }
        return new C2SUpdatePlayerDataPacket(dataType);
    }

    public void write(class_2540 buf) {
        if (this.dataTypeId() != null) {
            buf.writeBoolean(true);
            buf.method_10812(this.dataTypeId());
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketType<?> getType() {
        return TYPE;
    }
}

